#
#  (C) Tenable Network Security
#

if ( NASL_LEVEL < 3000 ) exit(0);

 desc = "
Synopsis :

It is possible to enumerate installed packages on the remote Solaris host, via 
SSH.

Description :

This plugin lists the packages installed on the remote Solaris host by calling 
pkginfo.

Solution :

Remove software that is not compliant with your company policy.

Risk factor : 

None";


if (description) {
  script_id(29217);
  script_version("$Revision: 1.2 $");

  script_name(english:"Solaris Package Enumeration (via SSH)");
  script_summary(english:"Displays the list of packages installed on the remote software"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"General");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("ssh_get_info.nasl");
  script_require_keys("Host/Solaris/pkginfo");

  exit(0);
}



pkg = get_kb_list("Solaris/Packages/Versions/*");
if ( isnull(pkg) ) exit(0);
report = NULL;
foreach name ( keys(pkg) )
{
 version = chomp(pkg[name]);
 name -= "Solaris/Packages/Versions/";
 report += name + " version " + version + '\n';
}

if ( strlen(report) )
{
 security_note(port:0, extra:'Here is the list of packages installed on the remote Solaris host :\n\n' + report);
}
