#
#  (C) Tenable Network Security, Inc.
#

desc = "
Synopsis :

The remote host has an anti-virus software installed on it. 

Description :

The remote Windows host is running Sophos Anti-Virus, a commercial
anti-virus. 

See also :

http://www.sophos.com/

Risk factor :

None";

if (description) 
{
  script_id(12215);
  script_version("$Revision: 1.15 $");

  script_name(english:"Sophos Anti-Virus detection");
  script_summary(english:"Checks for Sophos Anti-Virus"); 
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_enum_services.nasl", "smb_hotfixes.nasl");
  script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access", "SMB/transport");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");


if (!get_kb_item("SMB/registry_full_access")) exit(0);


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);


login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) 
{
  NetUseDel();
  exit(0);
}

# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}
	
# Determine where it's installed.
path = NULL;

key = "SOFTWARE\Sophos\SAVService\Application";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"Path");
  if (!isnull(value))
  {
    path = value[1];
    path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:path);

    set_kb_item(name:"Antivirus/Sophos/installed", value:TRUE);
  }
  RegCloseKey(handle:key_h);
}
if (isnull(path))
{
  RegCloseKey(handle:hklm);
  NetUseDel();
  exit(0);
}


# Determine the software version.
prod_ver = NULL;

list = get_kb_list("SMB/Registry/HKLM/SOFTWARE/Microsoft/Windows/CurrentVersion/Uninstall/*/DisplayName");
if (!isnull(list))
{
  # Use the installer's registry settings.
  foreach name (keys(list))
  {
    prod = list[name];
    if (prod && "Sophos Anti-Virus" >< prod)
    {
      key = ereg_replace(pattern:"^SMB\/Registry\/HKLM\/(.+)\/DisplayName$", replace:"\1", string:name);
      key = str_replace(find:"/", replace:"\", string:key);

      key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
      if (!isnull(key_h))
      {
        value = RegQueryValue(handle:key_h, item:"DisplayVersion");
        if (!isnull(value)) prod_ver = value[1];
        RegCloseKey(handle:key_h);
      }
      if (!isnull(prod_ver)) break;
    }
  }
}
RegCloseKey(handle:hklm);


# Find the engine version from veex.dll
eng_ver = NULL;

share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
dll_file =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\veex.dll", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}
fh = CreateFile(
  file:dll_file,
  desired_access:GENERIC_READ,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
if (!isnull(fh))
{
  v = GetFileVersion(handle:fh);
  CloseFile(handle:fh);

  if (!isnull(v))
  {
    eng_ver = string(v[0],".",v[1],".",v[2],".",v[3]);
  }
}
NetUseDel();


# Generate report.
trouble = 0;
latest_prod_ver = "7.1.0";
#latest_sigs_ver = "4.27";
latest_eng_ver = "2.51.0";

# - general info.
info = 'Sophos Anti-Virus is installed on the remote host :\n' +
       '\n' +
       '  Installation path : ' + path + '\n';
if (prod_ver)
{
  info += '  Product version   : ' + prod_ver + '\n';
  set_kb_item(name:"Antivirus/Sophos/prod_ver", value:prod_ver);
}
if (eng_ver)
{
  info += '  Engine version    : ' + eng_ver  + '\n';
  set_kb_item(name:"Antivirus/Sophos/eng_ver", value:eng_ver);
}
#if (sigs_ver) info += '  Virus signatures   : ' + sigs_ver + '\n';

# - product out of date?
if (!isnull(prod_ver))
{
  ver = split(prod_ver, sep:'.', keep:FALSE);
  for (i=0; i<max_index(ver); i++)
    ver[i] = int(ver[i]);

  fix = split(latest_prod_ver, sep:'.', keep:FALSE);
  for (i=0; i<max_index(fix); i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if (!isnull(fix[i]) && ver[i] < fix[i])
    {
      info += '\n' +
              'The product installed on the remote host is out-of-date - the last\n' +
              'known update from the vendor is ' + latest_prod_ver + '.\n';
      trouble++;
      break;
    }
    else if (isnull(fix[i]) || ver[i] > fix[i])
      break;
}
# - virus signatures out of date?
#if (!isnull(sigs_ver))
#{
#  ver = split(sigs_ver, sep:'.', keep:FALSE);
#  for (i=0; i<max_index(ver); i++)
#    ver[i] = int(ver[i]);
#
#  fix = split(latest_sigs_ver, sep:'.', keep:FALSE);
#  for (i=0; i<max_index(fix); i++)
#    fix[i] = int(fix[i]);
#
# for (i=0; i<max_index(ver); i++)
#    if (!isnull(fix[i]) && ver[i] < fix[i])
#    {
#      info += '\n' +
#              'The virus signatures on the remote host are out-of-date - the last\n' +
#              'known update from the vendor is ' + latest_sigs_ver + '.\n';
#      trouble++;
#      break;
#    }
#    else if (isnull(fix[i]) || ver[i] > fix[i])
#      break;
#}

# engine version out of date

if (!isnull(eng_ver))
{
  ver = split(eng_ver, sep:'.', keep:FALSE);
  for (i=0; i<max_index(ver); i++)
    ver[i] = int(ver[i]);

  fix = split(latest_eng_ver, sep:'.', keep:FALSE);
  for (i=0; i<max_index(fix); i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if (!isnull(fix[i]) && ver[i] < fix[i])
    {
      info += '\n' +
              'The engine version on the remote host is out-of-date - the last\n' +
              'known update from the vendor is ' + latest_eng_ver + '.\n';
      trouble++;
      break;
    }
    else if (isnull(fix[i]) || ver[i] > fix[i])
      break;
}

# - services running.
services = get_kb_item("SMB/svcs");
if (services && ("SAVService" >!< services))
{
  info += '\n' +
          'The Sophos Anti-Virus service (SAVService) is not running.\n';
  trouble++;
}

if (trouble) info += '\n' +
                     'As a result, the remote host might be infected by viruses.\n';

if (trouble)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    info
  );
  security_hole(port:port, data:report);
}
else
{
  # nb: antivirus.nasl uses this in its own report.
  set_kb_item (name:"Antivirus/Sophos/description", value:info);
}
