#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote proxy server is prone to a denial of service attack. 

Description :

According to its banner, the version of the Squid proxy caching server
installed on the remote host is older than 2.6.STABLE17.  Such
versions reportedly use incorrect bounds checking when processing some
cache update replies.  A client trusted to use the service may be able
to leverage this issue to crash the application, thereby denying
service to legitimate users. 

See also :

http://www.squid-cache.org/Advisories/SQUID-2007_2.txt
http://www.securityfocus.com/archive/1/484662/30/0/threaded

Solution :

Either upgrade to Squid version 2.6.STABLE17 or later or apply the
patch referenced in the project's advisory above. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";


if (description)
{
  script_id(29216);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-6239");
  script_bugtraq_id(26687);
  script_xref(name:"OSVDB", value:"39381");

  script_name(english:"Squid < 2.6.STABLE17 Denial of Service Vulnerability");
  script_summary(english:"Checks version of Squid");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("proxy_use.nasl");
  script_require_ports("Services/http_proxy",3128, 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


port = get_kb_item("Services/http_proxy");
if (!port)
{
  if (get_port_state(3128)) port = 3128;
  else port = 8080;
}
if (!get_port_state(port)) exit(0);


# Extract Squid's banner.
res = http_get_cache(item:"/", port:port);
if (res == NULL) exit(0);

if ("Squid/" >< res || "squid/" >< res)
{
  banner = NULL;
  pat = "([Ss]quid/[0-9]+\.[^ \)]+)";
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      val = eregmatch(pattern:pat, string:match);
      if (!isnull(val))
      {
        banner = val[1];
        break;
      }
    }
  }

  if (
    !isnull(banner) && 
    banner =~ "^[Ss]quid/([01]\.|2\.([0-5]\.|6\.STABLE([0-9][^0-9]*|1[0-6][^0-9]*)$))"
  )
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The remote Squid proxy returned the following banner :\n",
      "\n",
      "  ", banner, "\n",
      "\n",
      "Note that Nessus has not actually attempted to exploit this issue so\n",
      "it may be a false-positive.\n"
    );
    security_warning(port:port, data:report);
  }
}
