# Fixes by Tenable:
#   - added script_name.
#   - revised description.
#   - added script dependency
#   - added code to only run if report paranoia is "Paranoid".
#   - fixed regex.
#   - added report function.

if (description)
{
script_id(24870);
script_version("$Revision: 1.3 $");

script_cve_id("CVE-2007-0247", "CVE-2007-0248");
script_bugtraq_id(22079, 22203);
script_xref(name:"OSVDB", value:"32823");
script_xref(name:"OSVDB", value:"39839");

desc["english"] = "
Synopsis :

The remote proxy server is affected by multiple denial of service 
vulnerabilities.

Description :

Two vulnerabilities have been reported in Squid, which can be 
exploited by malicious people to cause a denial of service.

See also :

http://www.squid-cache.org/Versions/v2/2.6/squid-2.6.STABLE7-RELEASENOTES.html#s12

Solution : 

Upgrade to squid 2.6.STABLE7 or newer.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
script_description(english:desc["english"]);

script_name(english:"Squid < 2.6.STABLE7");
summary["english"] = "Determines squid version";
script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);
script_copyright(english: "(C) 2007 Shu-Ting Ou <mindlovemoon@gmail.com>");
family["english"] = "Denial of Service";
script_family(english:family["english"]);

script_dependencies("proxy_use.nasl");
script_require_ports("Services/http_proxy",3128, 8080);
exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

# nb: only run the plugin if we're being paranoid to avoid false-positives,
#     which might arise because the software is open-source.
if (report_paranoia < 2) exit(0);

port = get_kb_item("Services/http_proxy");
if(!port)port = 3128;
if(!get_port_state(port))port = 8080;

if(get_port_state(port))
{
 res = http_get_cache(item:"/", port:port);
 if(res && egrep(pattern:"[Ss]quid/2\.([0-5]\.|6\.STABLE[0-6][^0-9])", string:res))
   security_warning(port);
}
