#
# This script was originally written by Noam Rathaus <noamr@securiteam.com>, but was entirely
# rewritten by Tenable to use the ssh_func.inc API
#
#
# @@NOTE: The output of this plugin should not be changed
# 
#
#

desc["english"] = "
Synopsis :

An SSH server is listening on this port.

Description :

It is possible to obtain information about the remote SSH
server by sending an empty authentication request.

Risk factor :

None";



if(description)
{
 script_id(10267);
 script_version ("$Revision: 1.31 $");
 
 name["english"] = "SSH Server type and version";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "SSH Server type and version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) Tenable Network Security");
 family["english"] = "Service detection";
 script_family(english:family["english"]);
 script_require_ports("Services/ssh", 22);
 script_dependencies("find_service1.nasl", "find_service2.nasl", "external_svc_ident.nasl");
 exit(0);
}


#
# The script code starts here
#
include("misc_func.inc");
include("ssh_func.inc");
include("global_settings.inc");

port = get_kb_item("Services/ssh");

if (!port) port = 22;
if (get_port_state(port))
{
 version = NULL;
 if ( defined_func("bn_random") && !supplied_logins_only ) 
 {
  soc = open_sock_tcp(port);
  if ( ! soc ) exit(0);
  ssh_login (socket:soc, login:"n3ssus", password:"n3ssus", pub:NULL, priv:NULL, passphrase:NULL);

 version = get_ssh_server_version ();
 banner = get_ssh_banner ();
 supported = get_ssh_supported_authentication ();
 close(soc);
 }

 if ( isnull(version) )
 {
  soc = open_sock_tcp(port);
  if ( ! soc ) exit(0);
 version = recv_line(socket:soc, length:4096);
 if ( !ereg(pattern:"^SSH-", string:version ) ) exit(0);
 close(soc);
 }

 if (version)
 {
   set_kb_item(name:"SSH/banner/" + port, value:version);
   text = "SSH version : " + version + '\n';

   if (supported)
   {
     set_kb_item(name:"SSH/supportedauth/" + port, value:supported);
     text += 'SSH supported authentication : ' + supported + '\n';
   }
   
   if (banner)
   {
     set_kb_item(name:"SSH/textbanner/" + port, value:banner);
     text += 'SSH banner : \n' + banner + '\n';
   }

   report = string (desc["english"],
		"\n\nPlugin output :\n\n",
		text);
   
   security_note(port:port, data:report);
   register_service(port:port, proto: "ssh");   
 }
}
 
