#TRUSTED 3486380444a0a5cf5e9facef7a628c6111269441e7b544c531e524d7e6dbf0dc00e24429776bbc16c8262b25092a786055667748b05a5703150cb6297e03f39ef177ac90159d73cf1981db175053cafe0454ff95b20313c99f747998447aa50125081ccf4dcfb0f561b743391af6f73381319ed7f4d33ac257642aa991b79fb5b672f17d96b2983f6f344e07fc667d842dfabd874efd8d30467b664d0e890c28092eda50adce71f64996ae11798776083c3845de8ad482d43249546af69670acdf8b767685efd9e871afb01726f5481bb6be7193ee06106107c08ea718eac9847b930deffb53baa891c986189510a451b0f76cff4d3e1eeed208a05153d20d128df328090c6c27b8d913c3eac0e46418f10f63e6213f21432438044d7b4975c85506184537ac455059ddb46b7eb6855bb8c0e29dbbfc67f006cb7c3f271696f822c6c7992418d03b87bb93e6cabda56194ec9aada45c31623d6b96427a88e8791b3202f0afa20d71c5b242156712f9c96deb3197b6ae5539c6dd72ecc91640e543be4f9ede3aca8b0b304b7fb75d4cd436ebc6a6bfb7734632f9fcfabdc394942ae0158214c7716495468f154c1277408649f91b1248ab5ee5e4f6e5ba6cce3d16fb4cf82ec5445ac4c10213158b9a48bd11d8a35c84a6f29bd02951b18105a8d725bb1328a7a088cafc2108228878398b9c691b9bfa06835811f10d86dc28b2
#
# (C) Tenable Network Security
#
#

if(description)
{
 script_id(12634);
 script_version ("2.11");
 name["english"] = "Enable local security checks";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
This scripts logs into the remote host using SSH, RSH, RLOGIN, Telnet
or local commands and extracts the list of installed packages. 
To work properly, this script requires that you configure it with a valid 
SSH public key to use and eventually an SSH passphrase if the SSH public 
key is passphrase-protected or that you run it against localhost.";


 script_description(english:desc["english"]);
 
 summary["english"] = "Obtains the remote OS name and installed packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "General";
 script_family(english:family["english"]);
 
 script_dependencies("find_service1.nasl", "ssh_settings.nasl", "clrtxt_proto_settings.nasl");
# script_require_ports(22, "Services/ssh", 23, "Services/telnet", 512, 513, 514);
 exit(0);
}


include("ssh_func.inc");
include("telnet_func.inc");
include("hostlevel_funcs.inc");



#------------------------------------------------------------------------#
# Misc calls (all Unixes)						 #
#------------------------------------------------------------------------#

# cfengine version 

function misc_calls_and_exit()
{
 local_var ver;
 ver = info_send_cmd(cmd:"/usr/sbin/cfservd --help | grep ^cfengine | cut -d '-' -f 2");
 if ( ver )
  {
   ver = chomp(ver);
   set_kb_item(name:string("cfengine/version"), value:ver);
  }

 buf = info_send_cmd(cmd: '/sbin/ifconfig -a');
 if ( buf ) set_kb_item(name:"Host/ifconfig", value:buf);

 if (info_t == INFO_SSH) ssh_close_connection();
 else if (sock) close(sock);
 exit(0);
}

report = "";
info_t = 0;

#### Choose "transport" ####


ssh_failed = 0; 
telnet_failed = 0;
port_g = NULL; 
sock_g = NULL;

if (islocalhost() && defined_func("fread") && defined_func("pread"))
{
 info_t = INFO_LOCAL;
 set_kb_item(name: 'HostLevelChecks/proto', value: 'local');
}

if (! info_t)
{
 if (defined_func("bn_random"))
 {
  port22 = kb_ssh_transport();
  sock_g = ssh_login_or_reuse_connection();
  private_key = kb_ssh_privatekey();
 }
 if (sock_g)
 {
  info_t = INFO_SSH;
  set_kb_item(name: 'HostLevelChecks/proto', value: 'ssh');
  port_g = port22;
 }
 else 
 {
  ssh_failed = 1;
  if ( kb_ssh_login() && ( kb_ssh_password() || kb_ssh_privatekey() )  ) set_kb_item(name: 'HostLevelChecks/ssh/failed', value:TRUE);
  try_telnet = get_kb_item("HostLevelChecks/try_telnet");
  try_rlogin = get_kb_item("HostLevelChecks/try_rlogin");
  try_rsh    = get_kb_item("HostLevelChecks/try_rsh");
  try_rexec  = get_kb_item("HostLevelChecks/try_rexec");
  login      = get_kb_item("Secret/ClearTextAuth/login");
  pass       = get_kb_item("Secret/ClearTextAuth/pass");
 }
}


if (! info_t && try_rlogin && strlen(login) > 0)
{
 port513 = get_kb_item("Services/rlogin");
 if (! port513) port513 = 513;

 sock_g = rlogin(port: port513, login: login, pass: pass);
 if (sock_g)
 {
  info_t = INFO_RLOGIN;
  set_kb_item(name: 'HostLevelChecks/proto', value: 'rlogin');
  port_g = port513;
 }
 else
  {
  set_kb_item(name: 'HostLevelChecks/rlogin/failed', value:TRUE);
  rlogin_failed = 1;
  }
}

if (! info_t && try_rsh && strlen(login) > 0 )
{
 port514 = get_kb_item("Services/rsh");
 if (! port514) port514 = 514;
 r = send_rsh(port: port514, cmd: 'id');
 if ("uid=" >< r)
 {
  info_t = INFO_RSH;
  set_kb_item(name: 'HostLevelChecks/proto', value: 'rsh');
  port_g = port514;
 }
 else
  {
  set_kb_item(name: 'HostLevelChecks/rsh/failed', value:TRUE);
  rsh_failed = 1;
  }
}

if (! info_t && try_rexec && strlen(login) > 0)
{
 port512 = get_kb_item("Services/rexec");
 if (! port512) port512 = 512;
  r = send_rexec(port: port512, cmd: 'id');
 if ("uid=" >< r)
 {
  info_t = INFO_REXEC;
  set_kb_item(name: 'HostLevelChecks/proto', value: 'rexec');
  port_g = port512;
 }
 else
  {
  set_kb_item(name: 'HostLevelChecks/rexec/failed', value:TRUE);
  rexec_failed = 1;
  }
}


if (! info_t && try_telnet && strlen(login) > 0 && strlen(pass) > 0)
{
 port23 = get_kb_item("Services/telnet");
 if (! port23) port23 = 23;
  sock_g = telnet_open_cnx(port: port23, login: login, pass: pass);
 if (sock_g)
 {
  info_t = INFO_TELNET;
  set_kb_item(name: 'HostLevelChecks/proto', value: 'telnet');
  port_g = port23;
 }
 else
 {
  set_kb_item(name: 'HostLevelChecks/telnet/failed', value:TRUE);
  telnet_failed = 1;
 }
}

#

if (info_t == INFO_LOCAL)
 report = "Nessus can run commands on localhost to check if patches are applied";
else if (info_t == INFO_SSH && private_key)
	report = "It was possible to log into the remote host using the supplied asymetric keys"; 
else
	report = "It was possible to log into the remote host using the supplied password"; 

if ( info_t == 0 ) exit(0);


# Determine the remote operating system type

# Windows is not supported
buf = info_send_cmd(cmd: 'cmd /C ver');
if ( buf && ("Microsoft Windows" >< buf)) exit(0);


buf = info_send_cmd(cmd: 'uname -a');

if ( buf ) set_kb_item(name:"Host/uname", value:buf);
else {
	report += 
'\nHowever the execution of the command "uname -a" failed, so local security
checks have not been enabled';

	if (info_t == INFO_SSH)
	{
         error = ssh_cmd_error();
         if (strlen(error) > 0)
          report += '\n\nNessus return the following error message :\n' + error;
	}

	security_note(port:port, data:report);
	exit(0);
     }


report += '\nThe output of "uname -a" is :\n' + buf;


############################# FreeBSD ###########################################
if ( "FreeBSD" >< buf )
{
  release = ereg_replace(pattern:".*FreeBSD ([0-9]\.[^ ]*).*", replace:"\1", string:buf);
 items = split(release, sep:"-", keep:0);
 if ( "p" >< items[2] ) items[2] = ereg_replace(pattern:"p", replace:"_", string:items[2]);
 release = "FreeBSD-" + items[0] + items[2];
 set_kb_item(name:"Host/FreeBSD/release", value:release); 
 buf = info_send_cmd(cmd: "/usr/sbin/pkg_info");

  if ( ! buf )  {
	report += 
'\nThe command "pkg_info" did not return any result, therefore FreeBSD local 
security checks have not been enabled for this test';
	security_note(port:port, data:report);
	set_kb_item(name:'HostLevelChecks/failure', value:"'pkg_info' did not return any result");
	}
  else {
        set_kb_item(name:"Host/FreeBSD/pkg_info", value:buf);
	set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
        report += '\nLocal security checks have been enabled for this host.';
	security_note(port:port, data:report);
	misc_calls_and_exit();
	}
}
######################## RedHat Linux ###########################################
else if ("Linux" >< buf )
{
  buf = info_send_cmd(cmd: "cat /etc/vmware-release");
  if ( "VMware" >< buf )
  {
   set_kb_item(name:"Host/VMware/release", value:buf);
   buf = info_send_cmd(cmd: "/bin/rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'");
   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'rpm -qa' did not return any result");
    exit(0);
   }
   set_kb_item(name:"Host/VMware/rpm-list", value:buf);

   #report += '\nLocal security checks have been enabled for this host.';
   #set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
   #security_note(port:port, data:report);
   misc_calls_and_exit();
  }
  
  buf = info_send_cmd(cmd: "cat /etc/redhat-release");
  if ( egrep(pattern:"Red Hat.*(Enterprise|Advanced).*release ([345]|2\.1)", string:buf) ||
       egrep(pattern:"Fedora .*", string:buf) )
  {
   if ( "Red Hat" >< buf ) report += '\nThe remote Red Hat system is :\n' + buf;
   else if ("Fedora" >< buf ) report += '\nThe remote Fedora system is :\n' + buf;
   set_kb_item(name:"Host/RedHat/release", value:buf);
   buf = info_send_cmd(cmd: "/bin/rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'");

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'rpm -qa' did not return any result");
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/RedHat/rpm-list", value:buf);
   set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
   security_note(port:port, data:report);
   misc_calls_and_exit();
  }
 else if ( "CentOS" >< buf )
 {
   set_kb_item(name:"Host/CentOS/release", value:buf);
   buf = info_send_cmd(cmd: "/bin/rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'");
   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'rpm -qa' did not return any result");
    exit(0);
   }
   set_kb_item(name:"Host/CentOS/rpm-list", value:buf);

   buf = info_send_cmd(cmd:"uname -m");
   if ( ! buf )
   {
     report += 
'\nThe command "uname -m" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'uname -m' did not return any result");
    exit(0);
   }

   set_kb_item(name:"Host/cpu", value:buf);
   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
   security_note(port:port, data:report);
   misc_calls_and_exit();
 }
#####################   Mandrake ####################################################
#Mandrake Linux release 9.1 (Bamboo) for i586
  else
  {
  #buf = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");
  if (("Mandrake Linux" >< buf && "Mandrake Linux Corporate" >!< buf) || "Mandrakelinux" >< buf || 
	"Mandriva Linux release" >< buf )
  {
   report += '\nThe remote Mandrake system is :\n' + buf;
   version = ereg_replace(pattern:"(Mandrake Linux|Mandrakelinux|Mandriva Linux) release ([0-9]+\.[0-9]) .*", string:egrep(string:buf, pattern:"Mandr(ake|iva)"), replace:"\2");
   set_kb_item(name:"Host/Mandrake/release", value:"MDK" + version);
   
   #report += '\ndebug:\n' + version;
   
   buf = info_send_cmd(cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'");

   if ( ! buf )
   {
     report +=
'\nThe command "rpm -qa" did not produce any result, therefore local security
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'rpm -qa' did not return any result");
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/Mandrake/rpm-list", value:buf);
   set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
   security_note(port:port, data:report);
   misc_calls_and_exit();
  }
  }

###################### SuSE ###############################################################

  buf = info_send_cmd(cmd: "cat /etc/SuSE-release");

# SuSE Linux Enterprise Server says:
# SuSE SLES-8 (i386)
# VERSION = 8.1
# SuSE pro says:
# SuSE Linux 9.3 (i586)
# VERSION = 9.3
# Version 10.0 on Live CD says:
# SUSE LINUX 10.0 (i586)
# VERSION = 10.0

  if (buf && ("suse linux" >< tolower(buf) || "SuSE SLES" >< buf || "opensuse" >< tolower(buf) ))
  {
    version = '';
    report += '\nThe remote SuSE system is :\n' + egrep(pattern:"^SuSE", string:buf, icase:TRUE);
    version = egrep(string: buf, pattern: "^VERSION *= *[0-9.]+$");
    version = chomp(ereg_replace(pattern: "^VERSION *= *", string: version, replace: ""));
    if (! version)
    {
      v = eregmatch(pattern:"SuSE Linux ([0-9]+\.[0-9]) .*", 
		    string:egrep(string:buf, pattern:"SuSE ", icase:1), 
                    icase:TRUE);
      if (! isnull(v)) version = v[1];
    }
    if (! version)
    {
      report += '\nThis version of SuSE Linux could not be precisely identified,\ntherefore local securityhave been disabled';
      security_note(port:port, data:report);
      set_kb_item(name:'HostLevelChecks/failure', value:"Could not identify the version of the remote SuSE system");
      exit(0);
    }

	if ( "SUSE Linux Enterprise Desktop" >< buf )
	 set_kb_item(name:"Host/SuSE/release", value:"SLED" + version);
  	else if ( "SUSE Linux Enterprise Server" >< buf )
	 set_kb_item(name:"Host/SuSE/release", value:"SLES" + version);
	else
	 set_kb_item(name:"Host/SuSE/release", value:"SUSE" + version);
	buf = info_send_cmd(cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'");

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'rpm -qa' did not return any result");
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/SuSE/rpm-list", value:buf);
   set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
   security_note(port:port, data:report);
   misc_calls_and_exit();
  }
  
###################### Gentoo ###############################################

  buf = info_send_cmd(cmd: "cat /etc/gentoo-release");

  if ( buf && "Gentoo" >< buf )
  {
    if ( "Gentoo" >< buf )
      report += '\nThe remote Gentoo system is :\n' + egrep(pattern:"^Gentoo", string:buf);
    version = ereg_replace(pattern:"Gentoo Base System version (([0-9]+\.)*[0-9]+).*",
                             string:egrep(string:buf, pattern:"Gentoo"), replace:"\1");
    # Release does not make much sense on Gentoo
    set_kb_item(name:"Host/Gentoo/release", value: version);

    buf = info_send_cmd(cmd: 'egrep "ARCH=" /etc/make.profile/make.defaults');

    buf = ereg_replace(string: buf, pattern: 'ARCH="(.*)"', replace: "\1");
    set_kb_item(name: "Host/Gentoo/arch", value: buf);

    # A great idea from David Maciejak: 
    # 1. app-portage/gentoolkit is not necessarily installed 
    # 2. and this find is quicker than "qpkg -v -I -nc"
    # WARNING! We may catch files like -MERGING-* or *.portage_lockfile
    buf = info_send_cmd(cmd:'find /var/db/pkg/ -mindepth 2 -maxdepth 2 -printf "%P\\n"');
    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Gentoo/qpkg-list", value:buf);
      set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
      security_note(port:port, data:report);

      buf = info_send_cmd(cmd: "find /usr/portage/ -wholename '/usr/portage/*-*/*.ebuild' | sed 's,/usr/portage/\([^/]*\)/.*/\([^/]*\)\.ebuild$,\1/\2,'");
      if (buf)
       set_kb_item(name:"Host/Gentoo/ebuild-list", value: buf);
    }
    else
    {
      report += 
'For any reason, find did not produce any result, therefore local security 
checks have been disabled';
     set_kb_item(name:'HostLevelChecks/failure', value:"'find /var/db/pkg/' did not return any result");
     security_note(port:port, data:report);
    }
    misc_calls_and_exit();
    }

###################### Debian ###############################################
  buf = info_send_cmd(cmd: "cat /etc/debian_version");

  if ( buf && egrep(string:buf, pattern:'^([0-9.]+|testing/unstable|lenny/sid)[ \t\r\n]*$'))
  {
    report += '\nThe remote Debian system is :\n' + buf;
    debrel = chomp(buf);
    if (debrel == "testing/unstable") might_be_ubuntu = 1;

    if ( debrel =~ "^[0-3]\." )
     buf = info_send_cmd(cmd:'COLUMNS=160 dpkg -l');
    else
     buf = info_send_cmd(cmd:'dpkg -l|cat');

    if (buf)
    {
  	buf2 =  info_send_cmd(cmd: 'cat /etc/lsb-release');
        if ("DISTRIB_ID=Ubuntu" >< buf2)
        {
          set_kb_item(name: "Host/Ubuntu", value: TRUE);
          report += 'This is a Ubuntu system\n';
          debrel = NULL;
          x = egrep(string: buf2, pattern: "DISTRIB_RELEASE=");
          if (x) v = split(x, sep: '='); 
          if (x && max_index(v) > 0)
           set_kb_item(name: "Host/Ubuntu/release", value: v[1]);
         }
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Debian/dpkg-l", value:buf);
      set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, dpkg did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'dpkg' did not return any result");
    }
    if (debrel)
     set_kb_item(name:"Host/Debian/release", value: debrel);

   misc_calls_and_exit();
  }

###################### Slackware ########################################

  buf = info_send_cmd(cmd: 'cat /etc/slackware-version');

  if ("Slackware" >< buf)
  {
    buf = ereg_replace(string: buf, pattern: "^Slackware +", replace: "");
    report += '\nThe remote Slackware system is :\n' + buf;
    if (buf !~ '^[0-9.]+[ \t\r\n]*$')
    {
      report += '\nThe Slackware version is unknown, therefore 
local security checks have been disabled\n';
      security_note(port:port, data:report);
      exit(0);
    }
    set_kb_item(name:"Host/Slackware/release", value: chomp(buf));

    buf = info_send_cmd(cmd: 'ls -1 /var/log/packages');

    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Slackware/packages", value:buf);
      set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, /var/log/packages/ could not be read, 
therefore local security checks have been disabled';
    set_kb_item(name:'HostLevelChecks/failure', value:"'/var/log/packages' could not be read");
    security_note(port:port, data:report);
    }
    misc_calls_and_exit();
  }

  report += 
'\nThe remote Linux distribution is not supported, therefore local security checks have not been enabled';
  security_note(port:port, data:report);
  set_kb_item(name:'HostLevelChecks/failure', value:"Unsupported Linux distribution");
  misc_calls_and_exit();
}
######################## MacOS X ###########################################
else if ("Darwin" >< buf )
 {
  operating_system = ereg_replace(pattern:"^.*Darwin Kernel Version ([0-9]+\.[0-9]+\.[0-9]+):.*$", string:buf, replace:"\1");

  num = split(operating_system, sep:".", keep:FALSE);
  version = "Mac OS X 10." + string(int(num[0]) - 4) + "." + int(num[1]);


  buf = info_send_cmd(cmd: 'cat /private/etc/sysctl-macosxserver.conf');

  if ( "# /etc/sysctl-macosxserver.conf is reserved " >< buf  ) version = version + " Server";
  set_kb_item(name:"Host/MacOSX/Version", value:version);

  buf = info_send_cmd(cmd: 'ls /Library/Receipts');

  if ( ! buf )
  {
   report += 
'\nIt was not possible to get the list of installed package on the 
remote MacOS X system, therefore local security checks have
been disabled';
   security_note(port:port, data:report);
   set_kb_item(name:'HostLevelChecks/failure', value:"Could not obtain the list of installed packages");
   exit(0);
  }
  set_kb_item(name:"Host/MacOSX/packages", value:buf);

  if ( operating_system =~ "^(9\.|1[0-9]\.)" )
  {
   buf = info_send_cmd(cmd: 'ls /Library/Receipts/boms');
   if ( buf ) set_kb_item(name:"Host/MacOSX/packages/boms", value:buf);
  }
  report += '\nLocal security checks have been enabled for this host.';
  set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
  security_note(port:port, data:report);
  misc_calls_and_exit();
 }
######################## Solaris ###########################################
else if ( egrep(pattern:"SunOS.*", string:buf) )
{
 buf = info_send_cmd(cmd: 'showrev -a');

 if ( ! buf )
 {
  report += 
'\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  set_kb_item(name:'HostLevelChecks/failure', value:"'showrev -a' failed");
  exit(0);
 }

 set_kb_item(name:"Host/Solaris/showrev", value:buf);

 buf = egrep(pattern:"^Release: ", string:buf);
 buf -= "Release: ";
 set_kb_item(name:"Host/Solaris/Version", value:buf);

 buf = info_send_cmd(cmd: '/usr/bin/pkginfo -x | awk \'{ if ( NR % 2 ) { prev = $1 } else  { print prev" "$0  } }\'');


 if ( ! buf ) {
report = '\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  set_kb_item(name:'HostLevelChecks/failure', value:"'pkginfo' failed");
  exit(0);
 }


 array = split(buf, sep:'\n', keep:FALSE);
 foreach line ( array )
 {
  pkg = ereg_replace(pattern:"^([^ 	]*).*", replace:"\1", string:line);
  version = ereg_replace(pattern:"^" + pkg + " *\([^)]*\) (.*)", replace:"\1", string:line);
  set_kb_item(name:"Solaris/Packages/Versions/" + pkg, value:version);
 }

  set_kb_item(name:"Host/Solaris/pkginfo", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
  security_note(port:port, data:report);
  misc_calls_and_exit();
}
############################# AIX ##############################################
else if ( "AIX" >< buf )
{
  release = ereg_replace(pattern:".*AIX[ ]+.*[ ]+([0-9]+[ ]+[0-9]+)[ ]+.*", replace:"\1", string:buf);
  items = split(release, sep:" ", keep:0);
  release = "AIX-" + items[1] + "." + items[0];
  set_kb_item(name:"Host/AIX/version", value:release); 

  buf = info_send_cmd(cmd: "oslevel -r");

  if ( buf )  set_kb_item(name:"Host/AIX/oslevel", value:buf);

  buf = info_send_cmd(cmd: "lslpp -Lc");

  if ( ! buf ) {
    report += 
'\nThe command "lslpp -Lc" did not return any result, therefore
AIX local security checks have not been enabled for
this test';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'lslpp -Lc' failed");
    exit(0);
  }
  set_kb_item(name:"Host/AIX/lslpp", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
  security_note(port:port, data:report);
  misc_calls_and_exit();
}
############################# HP-UX ##############################################
else if ( "HP-UX" >< buf )
{
  release = ereg_replace(pattern:".*HP-UX[ ]+.*[ ]+B\.([0-9]+\.+[0-9]+)[ ]+.*", replace:"\1", string:buf);
  set_kb_item(name:"Host/HP-UX/version", value:release); 

  if ("ia64" >< buf)
    hardware = ereg_replace(pattern:".*HP-UX[ ]+.*[ ]+B\.[0-9]+\.+[0-9]+[ ]+.[ ]+ia64.*", replace:"800", string:buf);
  else
    hardware = ereg_replace(pattern:".*HP-UX[ ]+.*[ ]+B\.[0-9]+\.+[0-9]+[ ]+.[ ]+[0-9]+/(7|8)[0-9]+.*", replace:"\100", string:buf);
  set_kb_item(name:"Host/HP-UX/hardware", value:hardware); 
  buf = info_send_cmd(cmd:"/usr/sbin/swlist -l fileset -a revision");
  if ( !buf )  {
    report += 
'\nThe command "swlist -l fileset -a revision" did not return any result,
therefore HP-UX local security checks have not been enabled for
this test';
    security_note(port:port, data:report);
    set_kb_item(name:'HostLevelChecks/failure', value:"'swlist -l fileset -a revision' failed");
    exit(0);
  }

  set_kb_item(name:"Host/HP-UX/swlist", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  set_kb_item(name:'Host/local_checks_enabled', value: TRUE);
  security_note(port:port, data:report);
  misc_calls_and_exit();
}
