#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25627);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3504");
  script_bugtraq_id(24695);

  script_name(english:"Sun Java Web Start Arbitrary File Overwrite Vulnerability (102957)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by a
privilege escalation vulnerability. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) installed on the remote host reportedly may allow an untrusted
application to elevate its privileges by first granting itself
permission to overwrite any file that is writable by the user running
the the application. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-07/0013.html
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102957-1

Solution :

Update to Sun Java 2 JDK and JRE 5.0 Update 12 / SDK and JRE 1.4.2_14
/ SDK or later and remove if necessary any affected versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.5\.0_(0[0-9]|1[01])[^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-3][^0-9]?))", string:ver)
) security_hole(get_kb_item("SMB/transport"));
