#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25709);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-3716");
  script_bugtraq_id(24850);

  script_name(english:"Sun Java Runtime Environment XML Signature Command Injection Vulnerability (102993)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that may allow arbitrary
command injection.

Description :

The version of Sun Java Runtime Environment (JRE) installed on the
remote host reportedly does not securely process XSLT stylesheets
containing XSLT Transforms in XML Signatures.  If an attacker can pass
a specially-crafted XSLT stylesheet to a trusted Java application
running on the remote host, he may be able to execute arbitrary code
subject to the privileges under which the application operates. 

See also :

http://www.isecpartners.com/advisories/2007-04-dsig.txt
http://www.isecpartners.com/files/XMLDSIG_Command_Injection.pdf
http://www.securityfocus.com/archive/1/473552/30/0/threaded
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102993-1

Solution :

Upgrade to Sun Java JDK and JRE 6 Update 2 or later and remove any
affected versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.6\.0_0[01][^0-9]?", string:ver)
) security_hole(get_kb_item("SMB/transport"));
