#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31344);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2008-0657");
  script_bugtraq_id(27650);
  script_xref(name:"OSVDB", value:"41146");
  script_xref(name:"OSVDB", value:"41147");
  script_xref(name:"Secunia", value:"28795");

  script_name(english:"Sun Java Runtime Environment Privilege Escalation Vulnerability (231261)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by
privilege escalation vulnerabilities. 

Description :

The version of Sun Java Runtime Environment (JRE) installed on the
remote host reportedly contains two vulnerabilities that may
independently allow an untrusted application or applet to elevate its
privileges by, for example, granting itself permission to read and
write local files or execute local applications subject to the
privileges of the user running the application or applet. 

See also :

http://sunsolve.sun.com/search/document.do?assetkey=1-66-231261-1

Solution :

Upgrade to Sun JDK and JRE 6 Update 2 / JDK and JRE 5.0 Update 14 or
later and remove any affected versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


include("global_settings.inc");


# Check each installed JRE.
vers = get_kb_item("SMB/Java/JRE/Version");
if (isnull(vers)) exit(0);

info = "";
foreach ver (split(vers, sep:'\n', keep:FALSE))
{
  if (
    ver =~ "^1\.6\.0_0[01][^0-9]?" ||
    ver =~ "^1\.5\.0_(0[0-9]|1[0-3])[^0-9]?"
  ) info += '  - ' + ver + '\n';
}


# Report if any were found to be vulnerable.
if (info)
{
  if (report_verbosity)
  {
    report = string(
      "\n",
      "The following vulnerable instance(s) of Sun's JRE are installed on the\n",
      "remote host :\n",
      "\n",
      info
    );
    security_hole(port:get_kb_item("SMB/transport"), extra:report);
  }
  else security_hole(get_kb_item("SMB/transport"));
}
