#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30148);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-0012");
  script_bugtraq_id(27185);

  script_name(english:"Sun Java Runtime Environment jpiexp32.dll Denial of Service Vulnerability");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is prone to a denial
of service attack. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) installed on the remote host reportedly contains an issue in
'jpiexp32.dll' that can lead to a null pointer exception when an HTML
object references a Java applet but does not define the 'name'
attribute.  If a remote attacker can trick a user on the affected host
into visiting a specially-crafted web page, he may be able to leverage
this issue to cause the JRE and Internet Explorer to crash. 

See also :

http://research.corsaire.com/advisories/c060905-002.txt
http://www.securityfocus.com/archive/1/archive/1/485942/100/0/threaded

Solution :

Upgrade to Sun Java 2 JDK and JRE 5.0 update 14 or later. 

Risk factor : 

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:N/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


include("global_settings.inc");


# Check each installed JRE.
vers = get_kb_item("SMB/Java/JRE/Version");
if (isnull(vers)) exit(0);

info = "";
foreach ver (split(vers, sep:'\n', keep:FALSE))
{
  if (ver =~ "^1\.5\.0_(0[0-9]|1[0-3])[^0-9]?")
    info += '  - ' + ver + '\n';
}


# Report if any were found to be vulnerable.
if (info)
{
  if (report_verbosity)
  {
    report = string(
      "The following vulnerable instance(s) of Sun's JRE are installed on the\n",
      "remote host :\n",
      "\n",
      info
    );
    security_warning(port:get_kb_item("SMB/transport"), extra:report);
  }
  else security_warning(get_kb_item("SMB/transport"));
}
