#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27101);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: CASA: Securityfixes for problems found in audit. (CASA-1849)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch CASA-1849.

Description :

Various bugs and problems were fixed in the CASA
authentication framework, some of them security relevant:
- Secrets with special characters inside were handled
  incorrectly.
- Enhanced Salt generation.


Solution : 

Install the security patch CASA-1849.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the CASA-1849 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"CASA-1.6.659-1.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"CASA-32bit-1.6.659-1.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"CASA-64bit-1.6.659-1.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"CASA-devel-1.6.659-1.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"CASA-gui-1.6.659-1.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
