#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29347);
 script_cve_id("CVE-2006-3744", "CVE-2006-3743", "CVE-2006-4144");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ImageMagick (ImageMagick-2048)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ImageMagick-2048.

Description :

Several security problems have been fixed in ImageMagick:

- CVE-2006-3744: Several heap buffer overflow were found in
  the Sun Bitmap decoder of ImageMagick by an audit by the
  Google Security Team. This problem could be exploited by
  an attacker to execute code.

- CVE-2006-3743: Multiple buffer overflows were found in
  the XCF plugin due to incorrect bounds checking by the
  Google Security Team. This problem could be exploited by
  an attacker to execute code.

- CVE-2006-4144: A integer overflow in the ReadSGIImage
  function can be used by attackers to potentially execute
  code.

- An infinite loop in ImageMagick caused by TransformHSB
  was fixed.

- An infinite loop in handling of TIFF images was fixed.


Solution : 

Install the security patch ImageMagick-2048.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ImageMagick-2048 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ImageMagick-6.2.5-16.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ImageMagick-Magick++-6.2.5-16.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ImageMagick-devel-6.2.5-16.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
