#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29357);
 script_cve_id("CVE-2006-5464", "CVE-2006-5747", "CVE-2006-5748", "CVE-2006-5462", "CVE-2006-5463");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Mozilla Firefox (MozillaFirefox-2258)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaFirefox-2258.

Description :

This update brings MozillaFirefox to the security update
release 1.5.0.8,  including the following security fixes.

Full details can be found on:
http://www.mozilla.org/projects/security/known-vulnerabiliti
es.html

MFSA2006-65: Is split into 3 sub-entries, for ongoing
stability improvements in the Mozilla browsers:
CVE-2006-5464: Layout engine flaws were fixed.
CVE-2006-5747: A xml.prototype.hasOwnProperty flaw was
fixed. CVE-2006-5748: Fixes were applied to the Javascript
engine.

MFSA2006-66/CVE-2006-5462: MFSA 2006-60 reported that RSA
digital signatures with a low exponent (typically 3) could
be forged. Firefox and Thunderbird 1.5.0.7, which
incorporated NSS version 3.10.2, were incompletely patched
and remained vulnerable to a variant of this attack.

MFSA2006-67/CVE-2006-5463: shutdown demonstrated that it
was possible to modify a Script object while it was
executing, potentially leading to the execution of
arbitrary JavaScript bytecode.


Solution : 

Install the security patch MozillaFirefox-2258.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaFirefox-2258 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaFirefox-1.5.0.8-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-1.5.0.8-0.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-1.5.0.8-0.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-1.5.0.8-0.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
