#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28369);
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");

 script_version ("$Revision: 1.3 $");

 name["english"] = "SuSE Security Update: MozillaFirefox: Security update to version 2.0.0.10 (MozillaFirefox-4758)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaFirefox-4758.

Description :

This update brings Mozilla Firefox to security update
version 2.0.0.10

Following security problems were fixed: MFSA 2007-37 /
CVE-2007-5947: The jar protocol handler in Mozilla Firefox
retrieves the inner URL regardless of its MIME type, and
considers HTML documents within a jar archive to have the
same origin as the inner URL, which allows remote attackers
to conduct cross-site scripting (XSS) attacks via a jar:
URI.

MFSA 2007-38 / CVE-2007-5959:  The Firefox 2.0.0.10 update
contains fixes for three bugs that improve the stability of
the product. These crashes showed some evidence of memory
corruption under certain circumstances and we presume that
with enough effort at least some of these could be
exploited to run arbitrary code.

MFSA 2007-39 / CVE-2007-5960: Gregory Fleischer
demonstrated that it was possible to generate a fake HTTP
Referer header by exploiting a timing condition when
setting the window.location property. This could be used to
conduct a Cross-site Request Forgery (CSRF) attack against
websites that rely only on the Referer header as protection
against such attacks.


Solution : 

Install the security patch MozillaFirefox-4758.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaFirefox-4758 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaFirefox-2.0.0.10-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-2.0.0.10-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-2.0.0.10-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-2.0.0.10-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-2.0.0.10-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-2.0.0.10-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
