#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27126);
 script_cve_id("CVE-2006-4571", "CVE-2006-4570", "CVE-2006-4340", "CVE-2006-4253", "CVE-2006-4567", "CVE-2006-4565");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: MozillaThunderbird: Security update to version 1.5.0.7 (MozillaThunderbird-2100)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaThunderbird-2100.

Description :

This security update brings Mozilla Thunderbird to version
1.5.0.7.

More Details can be found on this page:
http://www.mozilla.org/projects/security/known-vulnerabiliti
es.html

It includes fixes to the following security problems: MFSA
2006-64/CVE-2006-4571: Crashes with evidence of memory
corruption MFSA 2006-63/CVE-2006-4570: JavaScript execution
in mail via XBL MFSA 2006-60/CVE-2006-4340/CERT VU#845620:
RSA Signature Forgery MFSA 2006-59/CVE-2006-4253:
Concurrency-related vulnerability MFSA
2006-58/CVE-2006-4567: Auto-Update compromise through DNS
and SSL spoofing MFSA 2006-57/CVE-2006-4565/CVE-2006-4566:
JavaScript Regular Expression Heap Corruption


Solution : 

Install the security patch MozillaThunderbird-2100.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaThunderbird-2100 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaThunderbird-1.5.0.7-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-translations-1.5.0.7-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
