#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27129);
 script_cve_id("CVE-2007-0775", "CVE-2007-0777", "CVE-2007-0008");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: MozillaThunderbird: Securityfix update to 1.5.0.10. (MozillaThunderbird-2734)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaThunderbird-2734.

Description :

This update brings Mozilla Thunderbird to version 1.5.0.10.
It contains stability fixes and some security fixes:

- MFSA 2007-01: As part of the Thunderbird 1.5.0.10 update
  releases several bugs were fixed to improve the stability
  of the browser. Some of these were crashes that showed
  evidence of memory corruption and we presume that with
  enough effort at least some of these could be exploited
  to run arbitrary code. These fixes affected the layout
  engine (CVE-2007-0775), SVG renderer (CVE-2007-0776) and
  javascript engine (CVE-2007-0777).

- MFSA 2007-06: CVE-2007-0008: SSL clients such as Firefox
  and Thunderbird can suffer a buffer overflow if a
  malicious server presents a certificate with a public key
  that is too small to encrypt the entire 'Master Secret'.
  Exploiting this overflow appears to be unreliable but
  possible if the SSLv2 protocol is enabled.


Solution : 

Install the security patch MozillaThunderbird-2734.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaThunderbird-2734 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaThunderbird-1.5.0.10-1.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-translations-1.5.0.10-1.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-1.5.0.10-1.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-translations-1.5.0.10-1.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
