#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27132);
 script_cve_id("CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3089", "CVE-2007-3737", "CVE-2007-3285", "CVE-2007-3670", "CVE-2007-3656", "CVE-2007-3738");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: MozillaThunderbird: Security update to fix various problems (MozillaThunderbird-3973)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaThunderbird-3973.

Description :

This update fixes several security problems in Mozilla
Thunderbird 1.5.0.12.

Following security problems were fixed:

- MFSA 2007-18: Crashes with evidence of memory corruption

  The usual collection of stability fixes for crashes that
look suspicious but haven't been proven to be exploitable.

  25 were in the browser engine, reported by  Mozilla
developers and community members Bernd Mielke, Boris
Zbarsky,  David Baron, Daniel Veditz, Jesse Ruderman, Lukas
Loehrer, Martijn Wargers, Mats Palmgren, Olli Pettay, Paul
Nickerson,and  Vladimir Sukhoy (CVE-2007-3734)

  7 were in the JavaScript engine reported by Asaf Romano,
Jesse Ruderman, Igor Bukanov (CVE-2007-3735)

- MFSA 2007-19 / CVE-2007-3736: XSS using addEventListener
  and setTimeout

  moz_bug_r_a4 reported that scripts could be injected into
another site's context by exploiting a timing issue using
addEventLstener or setTimeout.

- MFSA 2007-20 / CVE-2007-3089: frame spoofing

  Ronen Zilberman and Michal Zalewski both reported that it
was possible to exploit a timing issue to inject content
into about:blank frames in a page.

- MFSA 2007-21 / CVE-2007-3737:  Privilege escallation
  using an event handler attached to an element not in the
  document

  Reported by moz_bug_r_a4.

- MFSA 2007-22 / CVE-2007-3285: File type confusion due to
  %00 in name

  Ronald van den Heetkamp reported that a filename URL
containing %00 (encoded null) can cause Firefox to
interpret the file extension differently than the
underlying Windows operating system potentially leading to
unsafe actions such as running a program.

- MFSA 2007-23 / CVE-2007-3670: Remote code execution by
  launching Firefox from Internet Explorer

  Greg MacManus of iDefense and Billy Rios of Verisign
independently reported that links containing a quote (')
character could be used in Internet Explorer to launch
registered URL Protocol handlers with extra command-line
parameters. Firefox and Thunderbird are among those which
can be launched, and both support a '-chrome' option that
could be used to run malware.

  This problem does not affect Linux.

- MFSA 2007-24 / CVE-2007-3656: unauthorized access to
  wyciwyg:// documents

  Michal Zalewski reported that it was possible to bypass
the same-origin checks and read from cached (wyciwyg)
documents

- MFSA 2007-25 / CVE-2007-3738: XPCNativeWrapper pollution

  shutdown and moz_bug_r_a4 reported two separate ways to
modify an XPCNativeWrapper such that subsequent access by
the browser would result in executing user-supplied code.


Solution : 

Install the security patch MozillaThunderbird-3973.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaThunderbird-3973 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaThunderbird-1.5.0.12-3.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-translations-1.5.0.12-3.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
