#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29694);
 script_cve_id("CVE-2007-5339", "CVE-2007-5340");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: MozillaThunderbird: Security update to version 2.0.0.9 (MozillaThunderbird-4811)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch MozillaThunderbird-4811.

Description :

This update brings Mozilla Thunderbird to security update
version 2.0.0.9

Following security problems were fixed:
- MFSA 2007-29: Crashes with evidence of memory corruption
  As part of the Firefox 2.0.0.8 update releases Mozilla
  developers fixed many bugs to improve the stability of
  the product. Some of these crashes showed evidence of
  memory corruption under certain circumstances and we
  presume that with enough effort at least some of these
  could be exploited to run arbitrary code.

  - CVE-2007-5339 Browser crashes
  - CVE-2007-5340 JavaScript engine crashes

Also enigmail was upgraded to 0.95.5.


Solution : 

Install the security patch MozillaThunderbird-4811.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the MozillaThunderbird-4811 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"MozillaThunderbird-2.0.0.9-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-translations-2.0.0.9-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
