#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27135);
 script_cve_id("CVE-2006-5870");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: OpenOffice_org: Security fix for WMF buffer overflow. (OpenOffice_org-2408)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch OpenOffice_org-2408.

Description :

Following security problem was fixed in OpenOffice_org:

CVE-2006-5870: Bufferoverflows in WMF and Enhanced WMF
handling in OpenOffice_org
 could be used to potentially
execute code or crash OpenOffice_org.
 It is necessary that
the user can be tricked to open a prepared document.

This update also adds code to later hook in the OfficeXML
converter
 (odf-converter.sf.net).


Solution : 

Install the security patch OpenOffice_org-2408.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the OpenOffice_org-2408 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"OpenOffice_org-2.0.2-27.15", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"OpenOffice_org-gnome-2.0.2-27.15", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"OpenOffice_org-kde-2.0.2-27.15", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"OpenOffice_org-mono-2.0.2-27.15", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"OpenOffice_org-officebean-2.0.2-27.15", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
