#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:036
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24416);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:036: mysql";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:036 (mysql).


The database server MySQL was updated to fix the following security problems:

- Attackers could read portions of memory by using a user name with
trailing null byte or via COM_TABLE_DUMP command (CVE-2006-1516,
CVE-2006-1517).

- Attackers could potentially execute arbitrary code by causing a
buffer overflow via specially crafted COM_TABLE_DUMP packets
(CVE-2006-1518).

The mysql server package was released on May 30th already, the
mysql-Max server package was released on June 20th after additional
bugfixes.


Solution : http://www.novell.com/linux/security/advisories/2006_36_mysql.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mysql-4.1.13-3.4", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-4.0.18-32.23", release:"SUSE9.1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-Max-4.0.18-32.26", release:"SUSE9.1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-4.0.21-4.8", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-Max-4.0.21-4.8", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-4.1.10a-3.6", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"mysql-Max-4.1.10a-3.6", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
