#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:062
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24440);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:062: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:062 (openssh).


Several security problems were fixed in OpenSSH 4.4 and the bug fixes were
back ported to the openssh versions in our products.

- CVE-2006-4924: A denial of service problem has been fixed in OpenSSH which could
be used to cause lots of CPU consumption on a remote openssh server.

- CVE-2006-4925: If a remote attacker is able to inject network traffic this could
be used to cause a client connection to close.

- CVE-2006-5051: Fixed an unsafe signal handler reported by Mark Dowd. The signal
handler was vulnerable to a race condition that could be exploited to perform a
pre-authentication denial of service. This vulnerability could theoretically lead to
pre-authentication remote code execution if GSSAPI authentication is enabled,
but the likelihood of successful exploitation appears remote.

- CVE-2006-5052: Fixed a GSSAPI authentication abort that could be used to determine
the validity of user names on some platforms.



Solution : http://www.novell.com/linux/security/advisories/2006_62_openssh.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssh-4.1p1-10.9", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-4.1p1-10.9", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openssh-3.9p1-3.10", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-3.10", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openssh-3.9p1-12.8", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-12.8", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
