#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:069
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24446);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:069: asterisk";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:069 (asterisk).


Two security problem have been found and fixed in the PBX software
Asterisk.

CVE-2006-5444: Integer overflow in the get_input function in the
Skinny channel driver (chan_skinny.c) as used by Cisco SCCP phones,
allows remote attackers to potentially execute arbitrary code via a
certain dlen value that passes a signed integer comparison and leads
to a heap-based buffer overflow.

CVE-2006-5445: A vulnerability in the SIP channel driver
(channels/chan_sip.c) in Asterisk on SUSE Linux 10.1 allows remote
attackers to cause a denial of service (resource consumption)
via unspecified vectors that result in the creation of 'a real pvt
structure' that uses more resources than necessary.


Solution : http://www.novell.com/linux/security/advisories/2006_69_asterisk.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the asterisk package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"asterisk-1.0.9-4.6", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"asterisk-1.0.6-4.6", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
