#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:072
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24449);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:072: openldap2-client";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:072 (openldap2-client).


OpenLDAP libldap's strval2strlen() function contained a bug when
processing the authcid string of certain Bind Requests, which could
allow attackers to  cause an affected application (especially the
OpenLDAP Server) to crash.

This is tracked by the Mitre CVE ID CVE-2006-5779.


Solution : http://www.novell.com/linux/security/advisories/2006_72_openldap2.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openldap2-client package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openldap2-client-2.2.27-6.4", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"openldap2-client-2.2.23-6.6", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
