#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:076
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24451);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:076: libgsf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:076 (libgsf).


The libgsf library is used by various GNOME programs to handle for
instance OLE2 data streams.

Specially crafted OLE documents enabled attackers to use a heap buffer
overflow for potentially executing code.

This issue is tracked by the Mitre CVE ID CVE-2006-4514.


Solution : http://www.novell.com/linux/security/advisories/2006_76_libgsf.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgsf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libgsf-1.12.1-3.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"libgsf-1.11.1-4.2", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
