#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:007
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24461);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:007: cacti";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:007 (cacti).


A command injection in cmd.php in cacti was fixed, which might have
allowed remote attackers to inject commands and so execute code.

This issue is tracked by the Mitre CVE ID CVE-2006-6799.


Solution : http://www.novell.com/linux/security/advisories/2007_07_cacti.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cacti package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"cacti-0.8.6f-2.2", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"cacti-0.8.6e-2.5", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
