#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:008
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24462);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:008: XFree86-server,xorg-x11-server,xloader";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:008 (XFree86-server,xorg-x11-server,xloader).


This update fixes three memory corruptions within the X server which
could be used by local attackers with access to this display to crash
the X server and potentially execute code.

CVE-2006-6101: Integer overflow in the ProcRenderAddGlyphs function
in the Render extension for X.Org 6.8.2, 6.9.0, 7.0,
and 7.1, and XFree86 X server, allows local users to
execute arbitrary code via a crafted X protocol request
that triggers memory corruption during processing of
glyph management data structures.

CVE-2006-6102: Integer overflow in the ProcDbeGetVisualInfo function
in the DBE extension for X.Org 6.8.2, 6.9.0, 7.0,
and 7.1, and XFree86 X server, allows local users to
execute arbitrary code via a crafted X protocol request
that triggers memory corruption during processing of
unspecified data structures.

CVE-2006-6103: Integer overflow in the ProcDbeSwapBuffers function in
the DBE extension for X.Org 6.8.2, 6.9.0, 7.0, and 7.1,
and XFree86 X server, allows local users to execute
arbitrary code via a crafted X protocol request
that triggers memory corruption during processing of
unspecified data structures.


Solution : http://www.novell.com/linux/security/advisories/2007_08_x.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86-server,xorg-x11-server,xloader package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xorg-x11-server-6.8.2-100.10", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-6.8.2-30.10", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
