#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:009
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24463);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:009: opera";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:009 (opera).


This update brings the Opera Web browser to version 9.10, including
fixes for the following 2 security problems:

- CVE-2007-0126: Opera processes a JPEG DHT marker incorrectly, which
can potentially lead to remote code execution.

- CVE-2007-0127: Opera is affected by a typecasting bug in its
Javascripts SVG implementation which could potentially be used to
execute code.


Solution : http://www.novell.com/linux/security/advisories/2007_09_opera.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the opera package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"opera-9.10-3.1", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"opera-9.10-3.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
