#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:013
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24466);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:013: xine-ui,xine-lib,xine-extra,xine-devel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:013 (xine-ui,xine-lib,xine-extra,xine-devel).


This update fixes several format string bugs that can be exploited remotely
with user-assistance to execute arbitrary code.
Since SUSE Linux version 10.1 format string bugs are not exploitable
anymore. (CVE-2007-0017)



Solution : http://www.novell.com/linux/security/advisories/2007_13_xine.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xine-ui,xine-lib,xine-extra,xine-devel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xine-extra-1.1.0-0.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"xine-lib-1.1.0-0.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"xine-ui-0.99.4-84.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"xine-lib-1.0-10.14", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"xine-ui-1.0-10.14", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
