#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:015
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25405);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:015: AppArmor";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:015 (AppArmor).


Solution : http://www.novell.com/linux/security/advisories/2007_15_apparmor.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the AppArmor package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"subdomain-parser-common-1.2-35_imnx_suse", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"subdomain-parser-demo-1.2-35_imnx_suse", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"subdomain-profiles-1.2-14_imnx_suse", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"subdomain-utils-1.2-24", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"yast2-subdomain-1.2-13_imnx", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
