#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:041
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26175);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:041: freetype2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:041 (freetype2).


Solution : http://www.novell.com/linux/security/advisories/2007_41_freetype2.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the freetype2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"freetype2-2.1.10-4.9", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"freetype2-devel-2.1.10-4.9", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
