#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31126);
 script_cve_id("CVE-2008-0667", "CVE-2008-0726");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Acrobat Reader (acroread-5010)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch acroread-5010.

Description :

This version update to 8.1.2 fixes numerous bugs, including
some security problems. (CVE-2008-0667, CVE-2008-0655,
CVE-2008-0726)


Solution : 

Install the security patch acroread-5010.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the acroread-5010 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"acroread-8.1.2-1.4", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"acroread_ja-8.1.2-0.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
