#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31297);
 script_cve_id("CVE-2008-0883");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for acroread (acroread-5042)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch acroread-5042.

Description :

Adobe Acrobat Reader 8.1.2 contained a /tmp race in its
'acroread' wrapper script in the SSL certificate handling.
(CVE-2008-0883)

Furthermore it contained several duplicated copies of
system libraries, which have been removed for this update
to make sure they are up-to-date security wise by using the
system provided ones.


Solution : 

Install the security patch acroread-5042.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the acroread-5042 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"acroread-8.1.2-1.7", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"acroread_ja-8.1.2-0.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
