#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31319);
 script_cve_id("CVE-2006-7196", "CVE-2007-3382", "CVE-2007-3385", "CVE-2007-5641", "CVE-2007-1860", "CVE-2008-0128", "CVE-2005-2090");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: tomcat security update (apache2-mod_jk-4992)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch apache2-mod_jk-4992.

Description :

Fixed various issues in tomcat:
 - CVE-2006-7196: Cross-site scripting (XSS) vulnerability
   in example JSP applications
 - CVE-2007-3382: Handling of cookies containing a '
   character
 - CVE-2007-3385: Handling of \' in cookies
 - CVE-2007-5641: tomcat path traversal / information leak
 - CVE-2007-1860: directory traversal
 - CVE-2008-0128: tomcat https information disclosure
 - CVE-2005-2090: tomcat HTTP Request Smuggling


Solution : 

Install the security patch apache2-mod_jk-4992.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the apache2-mod_jk-4992 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mod_jk-ap20-4.1.30-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-5.0.30-27.21", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-admin-webapps-5.0.30-27.21", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-webapps-5.0.30-27.21", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"apache2-mod_jk-4.1.30-13.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-5.0.30-60", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-admin-webapps-5.0.30-60", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tomcat5-webapps-5.0.30-60", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
