#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29879);
 script_cve_id("CVE-2004-2680");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: apache2-mod_python: Fix possible memory leak. (apache2-mod_python-4448)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch apache2-mod_python-4448.

Description :

This update fixes a buffer overflow in apache2-mod_python
that occurs while using python-based output-filter. This
bug can be triggered remotely to read possibly confidential
data from the process space of the web-server and in rare
cases to execute arbitrary code. (CVE-2004-2680)


Solution : 

Install the security patch apache2-mod_python-4448.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the apache2-mod_python-4448 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"apache2-mod_python-3.1.3-60.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
