#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27154);
 script_cve_id("CVE-2006-2916");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: arts: Security Update to add missing setuid() return checks. (arts-1670)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch arts-1670.

Description :

The KDE soundserver aRts lacked checks around some setuid() 
calls.  This could potentially be used by a local attacker 
to gain root privileges. (CVE-2006-2916)


Solution : 

Install the security patch arts-1670.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the arts-1670 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"arts-1.5.1-15.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"arts-32bit-1.5.1-15.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"arts-64bit-1.5.1-15.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
