#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27155);
 script_cve_id("CVE-2006-2898");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: asterisk: Security Update for CVE-2006-2898 (asterisk-1676)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch asterisk-1676.

Description :

A security problem was fixed in the IAX2 channel driver of 
Asterisk that could be used by remote users to execute code 
or  at least crash Asterisk. This issue is tracked by the 
Mitre CVE ID  CVE-2006-2898.


Solution : 

Install the security patch asterisk-1676.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the asterisk-1676 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"asterisk-1.2.5-12.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
