#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27157);
 script_cve_id("CVE-2007-1561", "CVE-2007-2297");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: asterisk security update (asterisk-3543)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch asterisk-3543.

Description :

This update fixes multiple bugs that allowed attackers to
remotely crash asterisk or cause an information leak
(CVE-2007-1561, CVE-2007-1594, CVE-2007-1595,
CVE-2007-2297, CVE-2007-2488).


Solution : 

Install the security patch asterisk-3543.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the asterisk-3543 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"asterisk-1.2.5-12.12", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-1.2.13-23", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
