#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29381);
 script_cve_id("CVE-2006-5461");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for avahi (avahi-2216)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch avahi-2216.

Description :

Avahi did not check that the received netlink messages
originated from the kernel. This could be used by local
attackers to inject packets into avahi which could be used
to inject bad netlink messages into Avahi, confusing its
routing code or worse. (CVE-2006-5461)


Solution : 

Install the security patch avahi-2216.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the avahi-2216 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"avahi-0.6.5-29.8", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
