#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31320);
 
 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: Cacti: Multiple Vulnerabilities (cacti-5043)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cacti-5043.

Description :

This update fixes the following vulnerabilities:
- multiple XSS vulnerabilities
- path disclosure
- multiple SQL injections
- HTTP response splitting on very old PHP instances


Solution : 

Install the security patch cacti-5043.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cacti-5043 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cacti-0.8.6h-15.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cacti-0.8.6h-36.7", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cacti-0.8.6j-64.4", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
