#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(30192);
 script_cve_id("CVE-2007-5503");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for cairo (cairo-4961)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cairo-4961.

Description :

This update of cairo fixes several integer overflows while
decoding PNG images. This can be exploited remotely with
user-assistance to execute arbitrary code. (CVE-2007-5503)


Solution : 

Install the security patch cairo-4961.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cairo-4961 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cairo-1.0.2-27.21", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cairo-devel-1.0.2-27.21", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cairo-doc-1.0.2-27.21", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cairo-1.0.2-27.21", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cairo-devel-1.0.2-27.21", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cairo-doc-1.0.2-27.21", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
