#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27175);
 script_cve_id("CVE-2006-4182", "CVE-2006-5295");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: clamav: Security upgrade to version 0.88.5 (clamav-2180)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch clamav-2180.

Description :

Two security problems have been found and fixed in the
antivirus scan engine 'clamav', which could be used by
remote attackers sending prepared E-Mails containing
special crafted infected files to potentially execute code.

CVE-2006-4182: A problem in dealing with PE (Portable
Executables aka Windows .EXE) files could result in an
integer overflow, causing a heap overflow, which could be
used by attackers to potentially execute code.

CVE-2006-5295: A problem in dealing with CHM (compressed
helpfile) exists that could cause an invalid memory read,
causing the clamav engine to crash.


Solution : 

Install the security patch clamav-2180.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the clamav-2180 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"clamav-0.88.5-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
