#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27181);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update fixes various security bugs in ClamAV. (clamav-3531)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch clamav-3531.

Description :

This update of ClamAV fixes several security bugs.
- wrong calculation of buffer-end
- use strict permissions for temporary files
- heap corruption causing denial-of-service with corrupted
  rar archive
- detect block list loop


Solution : 

Install the security patch clamav-3531.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the clamav-3531 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"clamav-0.90.3-2.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"clamav-db-0.90.3-2.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
