#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29783);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: claws-mail security update (claws-mail-4835)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch claws-mail-4835.

Description :

clamav has been updated due to security problem. The
version number of the clamav library has been changed with
that update. Therefore programs like claws-mail that are
linked against libclamav need to be updated as well.


Solution : 

Install the security patch claws-mail-4835.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the claws-mail-4835 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"claws-mail-2.10.0-35.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"claws-mail-devel-2.10.0-35.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
