#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27189);
 script_cve_id("CVE-2006-2607");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Local privilege escalation in Cron. (cron-1440)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cron-1440.

Description :

A missing check on the return value of setuid() in 
vixie-cron could be used by a local user to gain root 
privileges by exhausting resource limits and waiting for a 
cronjob to trigger.  This is tracked by the Mitre CVE ID 
CVE-2006-2607.


Solution : 

Install the security patch cron-1440.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cron-1440 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cron-4.1-45.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
