#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27190);
 script_cve_id("CVE-2007-1856", "CVE-2005-1038");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: cron security update (cron-3092)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cron-3092.

Description :

By setting hard links to /etc/crontab users were able to
prevent cron from running scheduled jobs (CVE-2007-1856).

A re-emerged symlink bug allowed users to edit the crontab
of other users (CVE-2005-1038).


Solution : 

Install the security patch cron-3092.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cron-3092 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cron-4.1-45.10.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cron-4.1-70", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
