#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29408);
 script_cve_id("CVE-2007-1856", "CVE-2005-1038");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for cron (cron-3831)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cron-3831.

Description :

By setting hard links to /etc/crontab users were able to
prevent cron from running scheduled jobs (CVE-2007-1856).

A re-emerged symlink bug allowed users to edit the crontab
of other users (CVE-2005-1038).

This is a reissue of the SLES10 update after Service Pack
1, since Service Pack 1 merge lost some of the fixes in the
cron package.


Solution : 

Install the security patch cron-3831.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cron-3831 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cron-4.1-45.18", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cron-4.1-45.18", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
