#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28224);
 script_cve_id("CVE-2006-7217");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: derby: Fixed remote denial of service (derby-4091)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch derby-4091.

Description :

Apache Derby did not determine schema privilege
requirements during the DropSchemaNode bind phase, which
allows remote authenticated users to execute arbitrary drop
schema statements in SQL authorization mode. (CVE-2006-7217)

This update also brings a new requirement of a Java 1.5 JRE.


Solution : 

Install the security patch derby-4091.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the derby-4091 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"derby-10.3.1.4-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"derby-10.3.1.4-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
