#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31398);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ethereal (ethereal-5058)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ethereal-5058.

Description :

This update fixes the following bugs:
- the SCTP dissector could crash
- the SNMP dissector could crash
- the TFTP dissector could crash Wireshark (maybe a bug in
  the Cairo library on specific platforms)


Solution : 

Install the security patch ethereal-5058.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ethereal-5058 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ethereal-0.10.14-16.24", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-devel-0.10.14-16.24", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ethereal-0.10.14-16.24", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
