#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27210);
 script_cve_id("CVE-2007-1002");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: evolution: Security update (evolution-3960)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch evolution-3960.

Description :

Format string problems in the Memo Viewer of evolution
could be used to potentially execute code when viewing
shared memos. (CVE-2007-1002)


Solution : 

Install the security patch evolution-3960.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the evolution-3960 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"evolution-2.6.0-49.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.6.0-49.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-pilot-2.6.0-49.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-2.8.2-7", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.8.2-7", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-pilot-2.8.2-7", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
