#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27211);
 script_cve_id("CVE-2007-3257");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: evolution-data-server: Fixed security problem with malicious IMAP servers (evolution-data-server-3825)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch evolution-data-server-3825.

Description :

A malicious IMAP server could execute code within evolution
by sending a malformed  response to a SEQUENCE command.
(CVE-2007-3257)


Solution : 

Install the security patch evolution-data-server-3825.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the evolution-data-server-3825 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"evolution-data-server-1.6.0-43.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-32bit-1.6.0-43.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-64bit-1.6.0-43.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-devel-1.6.0-43.58", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-1.8.2-11", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-32bit-1.8.2-11", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-64bit-1.8.2-11", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"evolution-data-server-devel-1.8.2-11", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
